/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.vterm;

import com.ibm.hsc.access.api.AcaClient;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.exceptions.PIHscExceptionUtils;
import com.ibm.hsc.common.util.PIHmcAccessUtils;
import com.ibm.hsc.vterm.VSerialHelper;
import com.ibm.hsc.vterm.VSerialInfoClient;
import com.ibm.hsc.vterm.VSerialPartitionInfo;
import com.ibm.hsc.vterm.VSerialSystemInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMNameSpace;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMClient;
import org.snia.wbemcfg.GlobalConfig;

class VSerialInfoCIMClient
extends VSerialInfoClient {
    private static final String HMC_NAMESPACE = "root/ibmhsc_info";
    private static final String CLASS_CIMOM_INFO = "IBMHSC_CimomInfo";
    private static final String CLASS_SYSTEM = "IBMHSC_ComputerSystem";
    private static final String CLASS_PARTITION = "IBMHSC_Partition";
    private static final String ASSOC_PARTITION = "IBMHSC_CompSysPartition";
    private static final int STATE_READY = 1;
    private static final int STATE_NO_POWER = 3;
    private static final int STATE_INITIALIZING = 6;
    private static final int STATE_ERROR = 12;
    private static final int STATE_ERROR_DUMP_IN_PROCESS = 13;
    private static final int STATE_ERROR_TERMINATED = 14;
    private static final int STATE_CUOD_CTA = 15;
    private static final int STATE_CUOD_RECOVERY = 16;
    private static final int STATE_HYPERVISOR_STANDBY = 17;
    private static final int STATE_POWER_OFF_IN_PROCESS = 32;
    private static final int STATE_FSP_STATIC_FALLOVER_ERROR = 33;
    private static final int STATE_INCOMPLETE = 253;
    private static final int STATE_CONNECTIONLESS = 254;
    private static final int STATE_RECOVERY = 251;
    private static final int STATE_INCOMPATIBLE = 250;
    private static final int STATE_AUTH_DISCONNECTED = 240;
    private static final int STATE_AUTH_FAILED = 241;
    private static final int STATE_PW_UPDATES_REQD = 242;
    private static final int STATE_AUTH_CONNECTED = 243;
    private static final Map STATE_MAP;
    private List m_namespaces = new LinkedList();

    protected VSerialInfoCIMClient(VSerialHelper vSerialHelper, VSerialHelper.UPMapEntry uPMapEntry) throws SecurityException {
        super(vSerialHelper, uPMapEntry);
        this.login();
    }

    public static void newInstance(VSerialHelper vSerialHelper, Object object) throws SecurityException {
        if (object instanceof VSerialHelper.UPMapEntry) {
            VSerialHelper.UPMapEntry uPMapEntry = (VSerialHelper.UPMapEntry)object;
            uPMapEntry.setClient(new VSerialInfoCIMClient(vSerialHelper, uPMapEntry));
        }
    }

    public VSerialSystemInfo[] getSystemInformation() throws SecurityException {
        LinkedList<VSerialSystemInfo> linkedList = new LinkedList<VSerialSystemInfo>();
        Iterator iterator = this.m_namespaces.iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                CIMClient cIMClient = this.connectClient(string);
                CIMObjectPath cIMObjectPath = new CIMObjectPath(CLASS_SYSTEM, string);
                Enumeration enumeration = cIMClient.enumInstances(cIMObjectPath, false, false);
                while (enumeration.hasMoreElements()) {
                    CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                    VSerialSystemInfo vSerialSystemInfo = this.getSystemInfo(cIMInstance);
                    if (vSerialSystemInfo == null) continue;
                    linkedList.add(vSerialSystemInfo);
                }
                cIMClient.close();
            }
            catch (CIMException cIMException) {
                this.handleCIMException(cIMException);
            }
        }
        return linkedList.toArray(new VSerialSystemInfo[linkedList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public VSerialPartitionInfo[] getPartitionInformation(String string) throws SecurityException {
        block28: {
            CIMClient cIMClient;
            block24: {
                Object object;
                block25: {
                    VSerialPartitionInfo vSerialPartitionInfo;
                    Enumeration enumeration;
                    int n;
                    TreeMap<Integer, VSerialPartitionInfo> treeMap = new TreeMap<Integer, VSerialPartitionInfo>();
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = -1;
                    }
                    String string2 = null;
                    cIMClient = null;
                    CIMObjectPath cIMObjectPath = null;
                    Iterator iterator = this.m_namespaces.iterator();
                    boolean bl = false;
                    while (!bl && iterator.hasNext()) {
                        try {
                            string2 = (String)iterator.next();
                            VSerialHelper.logTrace("Looking for Cec: " + string + " in namespace: " + string2);
                            cIMClient = this.connectClient(string2);
                            enumeration = new CIMObjectPath(CLASS_SYSTEM, string2);
                            object = cIMClient.enumInstances((CIMObjectPath)enumeration, false, false);
                            while (object.hasMoreElements()) {
                                vSerialPartitionInfo = (CIMInstance)object.nextElement();
                                VSerialSystemInfo vSerialSystemInfo = this.getSystemInfo((CIMInstance)vSerialPartitionInfo);
                                if ((vSerialSystemInfo == null || !string.equals(vSerialSystemInfo.m_type_model_serial)) && vSerialSystemInfo.m_hardware_server_vport_tty != n) continue;
                                cIMObjectPath = new CIMObjectPath(CLASS_SYSTEM, string2);
                                cIMObjectPath.setKeys(vSerialPartitionInfo.getKeyValuePairs());
                                bl = true;
                                VSerialHelper.logTrace("Found Cec: " + string + " in namespace: " + string2);
                                break;
                            }
                            if (bl) continue;
                            cIMClient.close();
                        }
                        catch (CIMException cIMException) {
                            this.handleCIMException(cIMException);
                        }
                    }
                    if (cIMObjectPath == null) break block24;
                    enumeration = cIMClient.associators(cIMObjectPath, ASSOC_PARTITION, CLASS_PARTITION, "GroupComponent", "PartComponent", true, true, null);
                    if (enumeration == null) break block25;
                    while (enumeration.hasMoreElements()) {
                        object = (VSerialPartitionInfo[])enumeration.nextElement();
                        vSerialPartitionInfo = this.getPartitionInfo(cIMClient, (CIMInstance)object);
                        if (vSerialPartitionInfo == null) continue;
                        treeMap.put(new Integer(vSerialPartitionInfo.m_partition_id), vSerialPartitionInfo);
                    }
                    object = treeMap.values().toArray(new VSerialPartitionInfo[treeMap.size()]);
                    Object var14_16 = null;
                    try {
                        if (cIMClient != null) {
                            cIMClient.close();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return object;
                }
                VSerialHelper.logTrace("lpInsts is null");
                object = new VSerialPartitionInfo[]{};
                Object var14_17 = null;
                try {
                    if (cIMClient != null) {
                        cIMClient.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return object;
            }
            VSerialHelper.logTrace("Didn't find CEC!");
            Object var14_18 = null;
            try {
                if (cIMClient != null) {
                    cIMClient.close();
                }
                break block28;
            }
            catch (Throwable throwable) {}
            break block28;
            {
                catch (CIMException cIMException) {
                    this.handleCIMException(cIMException);
                    Object var14_19 = null;
                    try {
                        if (cIMClient != null) {
                            cIMClient.close();
                        }
                        break block28;
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
                Object var14_20 = null;
                try {
                    if (cIMClient != null) {
                        cIMClient.close();
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }

    protected void login() throws SecurityException {
        try {
            Object object;
            CIMClient cIMClient = this.connectClient(HMC_NAMESPACE);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(CLASS_CIMOM_INFO, HMC_NAMESPACE);
            Enumeration enumeration = cIMClient.enumInstances(cIMObjectPath, false, false);
            if (enumeration.hasMoreElements()) {
                object = (CIMInstance)enumeration.nextElement();
                cIMObjectPath.setKeys(object.getKeyValuePairs());
            }
            try {
                object = this.getHmcVersion();
            }
            catch (IOException iOException) {
                object = "V4R3.0";
                VSerialHelper.logTrace("Defaulting to version \"" + (String)object + "\"");
            }
            Vector<Object> vector = new Vector<Object>();
            Vector vector2 = new Vector();
            if (GlobalConfig.callMethodsWithValues) {
                vector.add(new CIMValue(object));
                vector.add(new CIMValue((Object)"POWER5"));
            } else {
                vector.add(new CIMProperty("HmcVersion", new CIMValue(object)));
                vector.add(new CIMProperty("NameSpaceType", new CIMValue((Object)"POWER5")));
            }
            CIMValue cIMValue = cIMClient.invokeMethod(cIMObjectPath, "getCurrentNameSpaces", vector, vector2);
            if (vector2 != null && vector2.size() > 0) {
                Object e = vector2.firstElement();
                CIMValue cIMValue2 = null;
                cIMValue2 = e instanceof CIMProperty ? ((CIMProperty)e).getValue() : (CIMValue)e;
                Vector vector3 = (Vector)cIMValue2.getValue();
                Iterator iterator = vector3.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (n == 0) {
                        VSerialHelper.logTrace("Current HMC version = " + string);
                    } else {
                        VSerialHelper.logTrace("Namespace = " + string);
                        if (!string.startsWith("root/")) {
                            string = "root/" + string;
                        }
                        this.m_namespaces.add(string);
                    }
                    ++n;
                }
            }
            cIMClient.close();
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = this.handleCIMException(cIMException);
            SecurityException securityException = new SecurityException(cIMException.getMessage());
            securityException.initCause(pIHscClientException);
            throw securityException;
        }
    }

    protected CIMClient connectClient(String string) throws CIMException {
        CIMNameSpace cIMNameSpace = new CIMNameSpace(this.m_helper.getHSIPAddr(), string);
        return new CIMClient(cIMNameSpace, this.m_entry.getU(), this.m_entry.getP());
    }

    protected String getHmcVersion() throws IOException {
        String string;
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec("/opt/hsc/bin/hsc version");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string).append("\n");
            if (string != null) continue;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString());
        int n = 0;
        String string2 = "";
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            if (n == 1) {
                string2 = string2 + "V" + string3;
            } else if (n == 3) {
                string2 = string2 + "R" + string3;
            }
            ++n;
        }
        return string2;
    }

    protected VSerialSystemInfo getSystemInfo(CIMInstance cIMInstance) {
        CIMProperty cIMProperty = null;
        CIMValue cIMValue = null;
        cIMProperty = cIMInstance.getProperty("Name");
        cIMValue = cIMProperty.getValue();
        String string = (String)cIMValue.getValue();
        cIMProperty = cIMInstance.getProperty("UserDefinedName");
        cIMValue = cIMProperty.getValue();
        String string2 = (String)cIMValue.getValue();
        cIMProperty = cIMInstance.getProperty("State");
        cIMValue = cIMProperty.getValue();
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMValue.getValue();
        cIMProperty = cIMInstance.getProperty("Vport");
        cIMValue = cIMProperty.getValue();
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)cIMValue.getValue();
        cIMProperty = cIMInstance.getProperty("TtyVport");
        cIMValue = cIMProperty.getValue();
        UnsignedInt32 unsignedInt322 = (UnsignedInt32)cIMValue.getValue();
        return new VSerialSystemInfo(string, string2, this.convertSystemState(unsignedInt8.intValue()), unsignedInt32.intValue(), unsignedInt322.intValue());
    }

    protected VSerialPartitionInfo getPartitionInfo(CIMClient cIMClient, CIMInstance cIMInstance) {
        Object object;
        CIMProperty cIMProperty = null;
        CIMValue cIMValue = null;
        cIMProperty = cIMInstance.getProperty("DefinitionState");
        cIMValue = cIMProperty.getValue();
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMValue.getValue();
        int n = unsignedInt8.intValue();
        VSerialHelper.logTrace("Slot Def state = 0x" + Integer.toHexString(n));
        if (n < 128 || n >= 144) {
            return null;
        }
        cIMProperty = cIMInstance.getProperty("PartitionState");
        cIMValue = cIMProperty.getValue();
        unsignedInt8 = (UnsignedInt8)cIMValue.getValue();
        n = unsignedInt8.intValue();
        cIMProperty = cIMInstance.getProperty("Name");
        cIMValue = cIMProperty.getValue();
        String string = (String)cIMValue.getValue();
        int n2 = Integer.parseInt(string.substring(0, string.indexOf(42)));
        cIMProperty = cIMInstance.getProperty("UserDefinedName");
        cIMValue = cIMProperty.getValue();
        String string2 = (String)cIMValue.getValue();
        CIMObjectPath cIMObjectPath = new CIMObjectPath(CLASS_PARTITION, cIMClient.getNameSpace().getNameSpace());
        cIMObjectPath.setKeys(cIMInstance.getKeyValuePairs());
        Vector<Object> vector = new Vector<Object>();
        if (GlobalConfig.callMethodsWithValues) {
            vector.add(new CIMValue((Object)new Boolean(false), new CIMDataType(10)));
        } else {
            vector.add(new CIMProperty("parseOptionData", new CIMValue((Object)new Boolean(false), new CIMDataType(10))));
        }
        Vector vector2 = new Vector();
        String string3 = "";
        try {
            object = cIMClient.invokeMethod(cIMObjectPath, "getCurrentSRC", vector, vector2);
            if (vector2.size() > 1) {
                Object e = vector2.elementAt(1);
                cIMValue = e instanceof CIMProperty ? ((CIMProperty)e).getValue() : (CIMValue)e;
                string3 = (String)cIMValue.getValue();
            }
        }
        catch (CIMException cIMException) {
            this.handleCIMException(cIMException);
        }
        int n3 = string3.lastIndexOf("|");
        object = n3 > 0 && n3 + 1 < string3.length() ? string3.substring(n3 + 1) : "";
        String string4 = this.getPermissions(cIMObjectPath);
        return new VSerialPartitionInfo(n2, n, (String)object, VSerialPartitionInfo.CONSOLE_STATE_UNKNOWN, "", string2, string4);
    }

    protected String getPermissions(CIMObjectPath cIMObjectPath) {
        AcaClient acaClient = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            acaClient = new AcaClient();
            if (acaClient.hasSuperRole(this.m_entry.getU())) {
                return "A";
            }
            String string = PIHmcAccessUtils.getInternalResInstId(cIMObjectPath);
            if (acaClient.CheckAccess(this.m_entry.getU(), "CMDPermission", string, "5250_C") == 0) {
                stringBuffer.append("C");
            }
            if (acaClient.CheckAccess(this.m_entry.getU(), "CMDPermission", string, "5250_W") == 0) {
                stringBuffer.append("W");
            }
            if (acaClient.CheckAccess(this.m_entry.getU(), "CMDPermission", string, "5250_D") == 0) {
                stringBuffer.append("D");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (acaClient != null) {
            acaClient.Finish();
        }
        System.out.println("Permissions: " + stringBuffer.toString() + "\n\n\n");
        return stringBuffer.toString();
    }

    protected int convertSystemState(int n) {
        Integer n2 = (Integer)STATE_MAP.get(new Integer(n));
        int n3 = n2 == null ? 255 : n2;
        return n3;
    }

    protected PIHscClientException handleCIMException(CIMException cIMException) {
        PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
        if (pIHscClientException == null) {
            pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            VSerialHelper.logTrace("CIMException: " + cIMException.getID() + ": " + cIMException.getMessage());
        } else {
            VSerialHelper.logTrace(pIHscClientException.getHscExId() + ": " + pIHscClientException.getMessage());
        }
        VSerialHelper.logCIMException(pIHscClientException);
        return pIHscClientException;
    }

    static {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(32);
        hashMap.put(new Integer(1), new Integer(0));
        hashMap.put(new Integer(3), new Integer(3));
        hashMap.put(new Integer(6), new Integer(1));
        hashMap.put(new Integer(12), new Integer(4));
        hashMap.put(new Integer(13), new Integer(4));
        hashMap.put(new Integer(14), new Integer(4));
        hashMap.put(new Integer(15), new Integer(1));
        hashMap.put(new Integer(16), new Integer(4));
        hashMap.put(new Integer(17), new Integer(6));
        hashMap.put(new Integer(32), new Integer(2));
        hashMap.put(new Integer(33), new Integer(4));
        hashMap.put(new Integer(253), new Integer(4));
        hashMap.put(new Integer(254), new Integer(5));
        hashMap.put(new Integer(251), new Integer(4));
        hashMap.put(new Integer(250), new Integer(4));
        hashMap.put(new Integer(240), new Integer(5));
        hashMap.put(new Integer(241), new Integer(5));
        hashMap.put(new Integer(242), new Integer(5));
        hashMap.put(new Integer(243), new Integer(5));
        STATE_MAP = Collections.unmodifiableMap(hashMap);
    }
}

